<?php

namespace App\Exceptions;

use Throwable;
use Spatie\Permission\Exceptions\UnauthorizedException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }
    public function render($request, Throwable $exception)
    {

        if ($exception instanceof MethodNotAllowedHttpException) {
            return response()->view('errors.405page', [
                'status'=>405,
                'message'=>'Method Not Allowed'
            ], 405);
        }elseif($exception instanceof NotFoundHttpException)
        {
            return response()->view('errors.404page', [
                'status'=>404,
                'message'=>'Not Found'
            ], 404);
        }
        elseif($exception instanceof UnauthorizedException)
        {
            return response()->view('backend.auth.unauth', [
                'status'=>403,
                'message'=>'User does not have the right permissions'
            ], 403);
        }
        return parent::render($request, $exception);
    }
}
