<?php

namespace App\Http\Controllers\Auth;

use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::ADMIN_DASHBOARD;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    public function showLoginForm()
    {
        $favicon=DB::table('settings')->where('key',Setting::FAVICON_KEY)->first();
        return view('backend.auth.login',compact('favicon'));
    }

    /**
     * The user has been authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  mixed  $user
     * @return mixed
     */
    protected function authenticated(Request $request, $user)
    {
        if($user->status == 'inactive')
        {
            Auth::logout();
            return redirect(RouteServiceProvider::HOME)->with('fail','Account expired!')->withInput();
        }
        $user->login_at=now();
        $user->save();
    }

    public function login(Request $request)
    {
        $credentials = $request->only(['email', 'password']);
        $validator = Validator::make($credentials, [
            'email' => 'required|email',
            'password' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/admin_login')->with('fail', 'Invalid Email address or Password');
        }
        if (Auth::guard()->attempt($credentials)) {
            if(auth()->user()->status == 'inactive')
            {
                Auth::logout();
                return redirect(RouteServiceProvider::HOME)->with('fail','Account expired!')->withInput();
            }
            auth()->user()->update(['login_at'=>now()]);
            return redirect('admin/dashboard');
        }
        else{
            return redirect('/admin_login')->with('fail', 'Invalid Email address or Password')->withInput($request->all());
        }
    }
    /**
     * Log the user out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\JsonResponse
     */
    public function logout(Request $request)
    {
        $this->guard()->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        if ($response = $this->loggedOut($request)) {
            return $response;
        }

        return $request->wantsJson()
            ? new JsonResponse([], 204)
            : redirect(RouteServiceProvider::HOME);
    }
}
