<?php

namespace App\Http\Controllers\Backend;

use App\Models\ContactUs;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Backend\Icon;
use App\Http\Requests\UpdateContactUsRequest;
use App\Repository\Backend\Interfaces\ContactUsRepositoryInterface;

class ContactUsController extends Controller
{
    /** @var ContactUsRepositoryInterface */
    private $contactusRepository;
    public function __construct(ContactUsRepositoryInterface $contactusRepo)
    {
        $this->contactusRepository = $contactusRepo;
        $this->middleware('permission:page_list', ['only' => ['index','show']]);
        $this->middleware('permission:page_edit', ['only' => ['edit','update']]);
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

        $logo1=ContactUs::find(1);
        $logo2=ContactUs::find(2);
        $logo3=ContactUs::find(3);
        $map=ContactUs::find(4);
        $data=[
            'logo1'=>$logo1,
            'logo2'=>$logo2,
            'logo3'=>$logo3,
            'map'=>$map,
        ];
        return view('backend.page.contactus.show',compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $icons= Icon::getFAIcons();//get icons from css file

        $logo1=ContactUs::find(1);
        $logo2=ContactUs::find(2);
        $logo3=ContactUs::find(3);
        $map=ContactUs::find(4);
        $data=[
            'logo1'=>$logo1,
            'logo2'=>$logo2,
            'logo3'=>$logo3,
            'map'=>$map,
            'icons'=>$icons,
        ];
        // dd($contactus);

        return view('backend.page.contactus.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateContactUsRequest $request, $id)
    {
        $input=$request->all();
        $contactus=$this->contactusRepository->update($input,$id);
        return redirect()->route('contactus.show','contactus')->with('success', 'Successfully Updated')->withInput($input);
    }
    public function deleteImage(Request $request)
    {
        $contact=ContactUs::where('type',$request->delete_image_type)->select('logo_url')->first();
        ContactUs::deleteImage($contact->logo_url);
        $contact->logo_url = null;
        $contact->update();
        save_logs('Delete '.$request->delete_image_type.' image of Contact us',$contact);
        return redirect()->back()->with('success', 'Successfully Updated')->withInput($request->all());
    }

}
