<?php

namespace App\Http\Controllers\Backend;

use App\Models\Home;
use App\Models\MenuItems;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\UpdateHomeRequest;
use App\Repository\Backend\Interfaces\HomeRepositoryInterface;

class HomeController extends Controller
{
    /** @var HomeRepositoryInterface */
    private $homeRepository;
    public function __construct(HomeRepositoryInterface $homeRepo)
    {
        $this->homeRepository = $homeRepo;
        $this->middleware('permission:page_list', ['only' => ['index','show']]);
        $this->middleware('permission:page_edit', ['only' => ['edit','update']]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $home=Home::first();
        // $post->body=json_decode($post->body);
        // $post->body_mm=json_decode($post->body_mm);
        return view('backend.page.home.show',compact('home'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $home=Home::first();
        // dd($home);

        // $input_body=json_decode($home->body);
        // foreach($input_body->blocks as $key=>$body)
        // {
        //     if(isset($body->type) && $body->type=='image' && (strpos($body->data->url, 'http://') === 0 || strpos($body->data->url, 'https://') === 0)) //if url
        //     {
        //         // Path to the image file
        //         $image_path = Home::IMAGE_PATH.basename($body->data->url);
        //         $image_file = Storage::disk('public')->get($image_path);
        //         // Encode the image data in Base64 format
        //         $base64_image = "data:image/jpg;base64,".base64_encode($image_file);

        //         $input_body->blocks[$key]->data->url=$base64_image;
        //     }
        // }
        // $home->body=json_encode($input_body);
        // //change body_mm image url to base64 encode
        // $input_body_mm=json_decode($home->body_mm);
        // foreach($input_body_mm->blocks as $key=>$body_mm)
        // {
        //     if(isset($body_mm->type) && $body_mm->type=='image' && (strpos($body_mm->data->url, 'http://') === 0 || strpos($body_mm->data->url, 'https://') === 0)) //if url
        //     {
        //         // Path to the image file
        //         $image_path = Home::IMAGE_PATH.basename($body_mm->data->url);
        //         $image_file = Storage::disk('public')->get($image_path);
        //         // Encode the image data in Base64 format
        //         $base64_image = "data:image/jpg;base64,".base64_encode($image_file);

        //         $input_body_mm->blocks[$key]->data->url=$base64_image;
        //     }
        // }
        // $home->body_mm=json_encode($input_body_mm);

        //for link to button
        $menus=MenuItems::leftjoin('menu_items as m','menu_items.id','m.parent')
            ->select('menu_items.id','menu_items.label','menu_items.label_mm')
            ->where('menu_items.status','active')
            ->where('m.id',null)
            ->orderBy('menu_items.sort')
            ->get();
        // dd($menus);
        return view('backend.page.home.edit', compact('home','menus'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateHomeRequest $request, $id)
    {
        // dd($request->all());
        $id=\Crypt::decrypt($id);
        $input=$request->all();
        $home=$this->homeRepository->update($input,$id);
        return redirect()->route('home.show','home')->with('success', 'Successfully Updated')->withInput($input);
    }

}
