<?php

namespace App\Http\Controllers\Backend;

use App\Models\Post;
use App\Models\Menus;
use App\Models\MenuItems;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class MenuController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:menu_list', ['only' => ['index','getMenuItem']]);
        $this->middleware('permission:menu_edit', ['only' => ['updateMenuItem','menuDrag']]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $menus = MenuItems::where('depth',1)->orderby('sort')->get();
        // get_menu_items_by_depth(NULL, 0);
        return view('backend.menu.index',compact('menus'));
    }

    public function getMenuItem(Request $request)
    {
        $menu=MenuItems::find(\Crypt::decrypt($request->id));
        $data=[
            'label'=>$menu->label,
            'label_mm'=>$menu->label_mm,
            'status'=>$menu->status,
        ];
        return response()->json(['data'=>$data]);
    }
    public function updateMenuItem(Request $request)
    {
        $request->validate([
            'label' => 'required|string',
            'label_mm' => 'required|string',
            'status' => 'required|string',
          ],
        [
            'label.required'=>'Label(English) field is required.',
            'label_mm.required'=>'Label(Myanmar) field is required.',
            'status.required'=>'Status field is required.',
        ]);
        $menu=MenuItems::find(\Crypt::decrypt($request->id));
        $menu->label=$request->label;
        $menu->label_mm=$request->label_mm;
        $menu->status=$request->status;
        $menu->save();
        save_logs('Update Menu',$menu);
        return redirect('/admin/menu');
    }

    public function menuDrag(Request $request)
    {
        $menu_array=json_decode($request->menu_array);
        if($menu_array == null) return redirect('/admin/menu');
        // dd($menu_array);
        $logs=[];
        foreach($menu_array as $key=>$menu)
        {
            $pare=MenuItems::find(\Crypt::decrypt($menu->id));
            $pare->parent=isset($menu->parent_id)?\Crypt::decrypt($menu->parent_id):0;
            $pare->depth=$menu->depth;
            $pare->sort=$key;
            $pare->save();
            array_push($logs,$pare);
        }
        save_logs('Drag Menu',$logs);
        return redirect('/admin/menu');
    }


}
