<?php

namespace App\Http\Controllers\Backend;

use App\Models\MenuItems;
use App\Models\Organization;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\UpdateOrganizationRequest;
use App\Repository\Backend\Interfaces\OrganizationRepositoryInterface;

class OrganizationController extends Controller
{
    /** @var OrganizationRepositoryInterface */
    private $orgRepository;
    public function __construct(OrganizationRepositoryInterface $orgRepo)
    {
        $this->orgRepository = $orgRepo;
        $this->middleware('permission:page_list', ['only' => ['index','show']]);
        $this->middleware('permission:page_edit', ['only' => ['edit','update']]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $org=Organization::first();
        // $post->body=json_decode($post->body);
        // $post->body_mm=json_decode($post->body_mm);
        return view('backend.page.organization.show',compact('org'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $org=Organization::first();

        return view('backend.page.organization.edit', compact('org'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateOrganizationRequest $request, $id)
    {
        // dd($request->all());
        $id=\Crypt::decrypt($id);
        $input=$request->all();
        $org=$this->orgRepository->update($input,$id);
        return redirect()->route('organization.show','org')->with('success', 'Successfully Updated')->withInput($input);
    }


}
