<?php

namespace App\Http\Controllers\Backend;

use App\Models\Menus;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PageController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:page-list', ['only' => ['index','getItems']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $menu = new Menus();
        $menulist = $menu->select(['id', 'name' ,'status'])->get();
        return view('backend.page.index',compact('menulist'));
    }

    /**
     * Display a sub listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getItem(Request $request)
    {
        $menu = new Menus();
        $menulist = $menu->select(['id', 'name','name_mm' ,'status'])->get();
        return view('backend.page.index',compact('menulist'));
    }


}
