<?php

namespace App\Http\Controllers\Backend;

use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\UpdateSettingRequest;
use App\Repository\Backend\Interfaces\SettingRepositoryInterface;

class SettingController extends Controller
{
    /** @var SettingRepositoryInterface */
    private $settingRepository;
    public function __construct(SettingRepositoryInterface $settingRepo)
    {
        $this->settingRepository = $settingRepo;
        $this->middleware('permission:setting_edit', ['only' => ['edit','update']]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $settings=Setting::all();
        $dateFormats=config('dateFormats.formats');
        //loop and set key value array
        $data=[];
        foreach($settings as $setting)
        {
            $data[$setting->key]['key']=$setting->key;
            $data[$setting->key]['value']=$setting->value;
            $data[$setting->key]['display_name']=$setting->display_name;

        }
        // dd($data);
        return view('backend.setting.edit',compact('data','dateFormats'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateSettingRequest $request, $id)
    {
        app()->setLocale($request->language);
        session()->put('locale', $request->language);
        $files=[];
        $content=[];
        foreach($request->all() as $key=>$value)
        {
            if($request->hasFile($key))
            {
                $files[$key]=$request->file($key);
            }else{
                $content[$key]=$value;
            }
        }
        $input['files']=$files;
        $input['content']=$content;
        $setting=$this->settingRepository->update($input,$id);
        return redirect()->route('setting.edit',\Crypt::encrypt('1'))->with('success', 'Successfully Updated')->withInput($input);
    }
    public function deleteImage(Request $request)
    {
        $setting=Setting::where('key',$request->delete_image_type)->select('value')->first();
        Setting::deleteImage($setting->value);
        $setting->value = null;
        $setting->update();
        save_logs('Delete '.$request->delete_image_type.' image of Setting',$setting);
        return redirect()->back()->with('success', 'Successfully Updated')->withInput($request->all());
    }


}
