<?php

namespace App\Http\Controllers\Backend;

use App\Models\Suggestion;
use Illuminate\Http\Request;
use App\Models\DeletedSuggestion;
use DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use App\Http\Requests\StoreSuggestionRequest;
use App\Repository\Backend\Interfaces\SuggestionRepositoryInterface;

class SuggestionController extends Controller
{
    /** @var SuggestionRepositoryInterface */
    private $suggestionRepository;
    public function __construct(SuggestionRepositoryInterface $suggestionRepo)
    {
        $this->suggestionRepository = $suggestionRepo;
        $this->middleware('permission:page_list', ['only' => ['index','show']]);
        // $this->middleware('permission:page_create', ['only' => ['create','store']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // dd($request->all());
        $paginate=10;
        $order_by=$request->order_by??'suggestions.id';
        $direction=$request->direction??'desc';
        $input = $request->all();
        $input['order_by']=$order_by;
        $input['direction']=$direction;
        $input['paginate']=$paginate;
        $suggestions = $this->suggestionRepository->all($input);
        // dd($suggestions);
        return view('backend.page.suggestion.index',compact('suggestions','order_by','direction'))->withInput($input);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.page.suggestion.testcreate');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreSuggestionRequest $request)
    {
        // dd($request->all());
        $input=$request->all();
        $this->suggestionRepository->store($input);
        return redirect('admin/suggestion')->with('success', 'New suggestion successfully added');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id=\Crypt::decrypt($id);
        $suggestion=Suggestion::findorfail($id);
        save_logs('View Suggestion',$suggestion);
        return view('backend.page.suggestion.show',compact('suggestion'));
    }
    public function destroy()
    {

        try {
            DB::beginTransaction();
            $id = Crypt::decrypt(request()->id);

            $suggestion = Suggestion::findorfail($id);

            $bk_sug=new DeletedSuggestion;
            $bk_sug->name=$suggestion->name;
            $bk_sug->phone=$suggestion->phone;
            $bk_sug->nrc=$suggestion->nrc;
            $bk_sug->email=$suggestion->email;
            $bk_sug->address=$suggestion->address;
            $bk_sug->message=$suggestion->message;
            $bk_sug->suggestion_date=$suggestion->created_at;
            $bk_sug->deleted_at=date('Y-m-d');
            $bk_sug->deleted_by=Auth::id() == 1?2:Auth::id();
            $bk_sug->save();


            save_logs('Delete suggestion', $suggestion);
            $delete = $suggestion->delete();
            DB::commit();
            return redirect('admin/suggestion')->with(['success' => 'Suggestion information successfully delete']);
        } catch (\Illuminate\Database\QueryException $e) {
            DB::rollBack();
            return redirect('admin/suggestion')->with(['fail' => 'Error deleting record'], 500);
        }
    }

}
