<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Home;
use App\Models\Post;
use App\Models\ContactUs;
use App\Models\MenuItems;
use App\Models\Organization;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreSuggestionRequest;
use App\Repository\Backend\Interfaces\SuggestionRepositoryInterface;

class PageController extends Controller
{
    private $suggestionRepository;
    public function __construct(SuggestionRepositoryInterface $suggestionRepo)
    {
        $this->suggestionRepository = $suggestionRepo;
        // $this->middleware('permission:page_create', ['only' => ['create','store']]);
    }
    public function home()
    {
        $sliders=Post::select('id','feature_image','title')
            ->where('status','active')
            ->where('slider','active')
            ->orderBy('id','desc')
            ->get();
        $home=Home::select('id','title','title_mm','body','body_mm','link_to','meta_keyword','meta_description')->first();
        $latestNews=Post::select('id','title','title_mm','slug','feature_image','created_at')
            ->where('menu_item_id',MenuItems::NEW_ID)
            ->where('status','active')
            ->take(4)
            ->orderBy('id','desc')
            ->get();
        return view('frontend.index',compact('sliders','home','latestNews'));
    }
    public function organization()
    {
        $data=Organization::first();
        return view('frontend.company',compact('data'));
    }
    public function contactUs()
    {
        $logo1=ContactUs::find(1);
        $logo2=ContactUs::find(2);
        $logo3=ContactUs::find(3);
        $map=ContactUs::find(4);
        $data=[
            'logo1'=>$logo1,
            'logo2'=>$logo2,
            'logo3'=>$logo3,
            'map'=>$map,
        ];
        return view('frontend.contact-us',compact('data'));
    }
    public function storeSuggestion(StoreSuggestionRequest $request)
    {
        // dd($request->all());
        $input=$request->all();
        $this->suggestionRepository->store($input);
        return redirect()->back()->with('success', 'New suggestion successfully added');
    }
}
