<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Book;
use App\Models\Post;
use App\Models\Video;
use App\Models\MenuItems;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class PostController extends Controller
{
    public function news(Request $request)
    {
        $news=Post::where('status','active')
            ->select('feature_image','slug','title','title_mm','created_at')
            ->where('menu_item_id',MenuItems::NEW_ID)
            ->orderBy('id','desc')
            ->paginate(16);
        return view('frontend.news',compact('news'));
    }
    public function newDetail(Request $request,$slug)
    {
        $new=Post::where('slug',$slug)
            ->select('feature_image','title','title_mm','body','body_mm','meta_keyword','meta_description')
            ->first();
        return view('frontend.news-detail',compact('new'));
    }
    public function awareness()
    {
        $videos=Video::select('title','title_mm','slug','link','created_at','meta_keyword')
            ->orderBy('id','desc')
            ->paginate(4,['*'], 'videos');
        $posts=Post::select('title','title_mm','slug','created_at','feature_image')
            ->where('status','active')
            ->where('menu_item_id',MenuItems::AWARENESS_ID)
            ->orderBy('id','desc')
            ->paginate(4,['*'], 'posts');
        $books=Book::select('title','title_mm','slug','created_at','file_url','meta_keyword')
            ->where('status','active')
            ->orderBy('id','desc')
            ->paginate(4,['*'], 'books');
        $bookMetaKeywords = $books->pluck('meta_keyword')->toArray();
        $videoMetaKeywords = $videos->pluck('meta_keyword')->toArray();
        $combinedMetaKeywords = array_merge($bookMetaKeywords, $videoMetaKeywords);
        $metaKeywords = implode(', ', $combinedMetaKeywords);

        return view('frontend.awareness',compact('videos','posts','books','metaKeywords'));
    }
    public function search(Request $request)
    {
        $rules = [
            'search' => 'required|string|max:255',
        ];
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            // Validation failed, return the error messages
            return redirect()->back()->with('errors' , $validator->errors());
        }
        $search = $request->search;
        $posts=Post::where('title','like','%'.$request->search.'%')
            ->orWhere('title_mm','like','%'.$request->search.'%')
            ->where('status','active')
            ->paginate(12);

        return view('frontend.search',compact('posts','search'));
    }
}
