<?php

namespace App\Http\Requests;

use App\Rules\FileCount;
use Illuminate\Foundation\Http\FormRequest;

class StoreBookRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title'=>['required','max:255'],
            'title_mm'=>['required','max:255'],
            'file_url'=>['required','mimes:pdf','max:524288'], //512MB
            'meta_keyword'=>['nullable','string','max:255'],
            'meta_description'=>['nullable','string','max:65535'],
        ];
    }
    public function messages()
    {
        return [
            'file_url.mimes'=>'Attached file must be pdf format.',

        ];
    }
}
