<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePostRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => ['required', 'string', 'max:65535'],
            'title_mm' => ['required', 'string', 'max:65535'],
            'body' => ['required', 'string', 'max:4294967295'],
            'body_mm' => ['required', 'string', 'max:4294967295'],
            'feature_image' => [
                'required', 'max:1048576', 'max:1048576', 'mimes:jpg,png,jpeg,gif,svg',
                function ($attribute, $value, $fail) {
                    /** @var UploadedFile $value */
                    $extension = strtolower($value->getClientOriginalExtension());
                    if ($extension === 'jfif') {
                        $fail('The uploaded image must be a valid image file (JPEG, PNG, JPG, GIF, SVG).');
                    }
                },
            ],
            'meta_keyword' => ['nullable', 'string', 'max:65535'],
            'meta_description' => ['nullable', 'string', 'max:65535'],
            'files.*' => ['mimes:jpeg,png,jpg,gif,svg,pdf', 'max:1048576'], //1GB
            'status' => ['nullable', 'string', 'max:10'],
            'slider' => ['nullable', 'string', 'max:10'],
        ];
    }
    public function messages()
    {
        return [
            'title_en.required' => 'Please filled your title (English) .',
            'title_mm.required' => 'Please filled your title (Myanmar) .',
            'body.required' => 'Please filled your body (English)',
            'body_mm.required' => 'Please filled your body (Myanmar)',
        ];
    }
}
