<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class StoreRoleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'=>['required','string','max:255',Rule::unique('roles', 'name')],
            'permissions'=>'required'
        ];
    }
    public function messages()
    {
        return [
            'permissions.required'=>'Please choose the permissions for this role.'
        ];
    }
}
