<?php

namespace App\Http\Requests;

use App\Rules\FileCount;
use Illuminate\Foundation\Http\FormRequest;

class StoreSuggestionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'=>['required','string','max:255'],
            'phone'=>['required','string','max:255'],
            'nrc'=>['required','string','max:255'],
            'email'=>['nullable','email','string','max:255'],
            'address'=>['required','string','max:65535'],
            'message'=>['required','string','max:65535'],
            // 'files' => ['required', new FileCount(1, 2)],
            // 'files.*'=>['mimes:pdf','max:1048576']
        ];
    }
}
