<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateContactUsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'logo1_url' => [
                'nullable',
                'max:1048576', 'mimes:jpg,png,jpeg,gif,svg',
                function ($attribute, $value, $fail) {
                    /** @var UploadedFile $value */
                    $extension = strtolower($value->getClientOriginalExtension());
                    if ($extension === 'jfif') {
                        $fail('The uploaded image must be a valid image file (JPEG, PNG, JPG, GIF, SVG).');
                    }
                },
            ],
            'logo2_url' => [
                'nullable', 'max:1048576', 'mimes:jpg,png,jpeg,gif,svg',
                function ($attribute, $value, $fail) {
                    /** @var UploadedFile $value */
                    $extension = strtolower($value->getClientOriginalExtension());
                    if ($extension === 'jfif') {
                        $fail('The uploaded image must be a valid image file (JPEG, PNG, JPG, GIF, SVG).');
                    }
                },
            ],
            'logo3_url' => [
                'nullable', 'max:1048576', 'mimes:jpg,png,jpeg,gif,svg',
                function ($attribute, $value, $fail) {
                    /** @var UploadedFile $value */
                    $extension = strtolower($value->getClientOriginalExtension());
                    if ($extension === 'jfif') {
                        $fail('The uploaded image must be a valid image file (JPEG, PNG, JPG, GIF, SVG).');
                    }
                },
            ],
            'title.*' => ['required', 'string', 'max:255'],
            'title_mm.*' => ['required', 'string', 'max:255'],
            'desc.*' => ['required', 'string', 'max:65535'],
            'desc_mm.*' => ['required', 'string', 'max:65535'],
            'map_frame' => ['required', 'string', 'max:65535'],
        ];
    }
    public function messages()
    {
        return [
            'logo1_url.mimes' => 'Logo image of phone must be type of jpeg|png|jpg|gif|svg.',
            'logo2_url.mimes' => 'Logo image of email must be type of jpeg|png|jpg|gif|svg.',
            'logo3_url.mimes' => 'Logo image of address must be type of jpeg|png|jpg|gif|svg.',

            'title.0.required' => 'Title(English) of phone is required.',
            'title.1.required' => 'Title(English) of email is required.',
            'title.2.required' => 'Title(English) of address is required.',

            'title_mm.0.required' => 'Title(Myanmar) of phone is required.',
            'title_mm.1.required' => 'Title(Myanmar) of email is required.',
            'title_mm.2.required' => 'Title(Myanmar) of address is required.',

            'desc.0.required' => 'Description(English) of phone is required.',
            'desc.1.required' => 'Description(English) of email is required.',
            'desc.2.required' => 'Description(English) of address is required.',

            'desc_mm.0.required' => 'Description(Myanmar) of phone is required.',
            'desc_mm.1.required' => 'Description(Myanmar) of email is required.',
            'desc_mm.2.required' => 'Description(Myanmar) of address is required.',

            'map_frame.required' => 'Map frame is required.',
        ];
    }
}
