<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateHomeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title'=>['required','string','max:255'],
            'title_mm'=>['required','string','max:255'],
            'body'=>['required','string','max:4294967295'],
            'body_mm'=>['required','string','max:4294967295'],
            'meta_keyword'=>['nullable','string','max:255'],
            'meta_description'=>['nullable','string','max:65535'],
        ];
    }
}
