<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateOrganizationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'body' => ['required', 'string', 'max:4294967295'],
            'body_mm' => ['required', 'string', 'max:4294967295'],
            'feature_image' => [
                'nullable', 'max:1048576', 'mimes:jpg,png,jpeg,gif,svg',
                function ($attribute, $value, $fail) {
                    /** @var UploadedFile $value */
                    $extension = strtolower($value->getClientOriginalExtension());
                    if ($extension === 'jfif') {
                        $fail('The uploaded image must be a valid image file (JPEG, PNG, JPG, GIF, SVG).');
                    }
                },
            ],
            'meta_keyword' => ['nullable', 'string', 'max:255'],
            'meta_description' => ['nullable', 'string', 'max:65535'],
        ];
    }
    public function messages()
    {
        return [
            'body.required' => 'Please filled your body (English) .',
            'body_mm.required' => 'Please filled your body (Myanmar) .',
        ];
    }
}
