<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class UpdateProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $user_id = \Crypt::decrypt($this->route('profile'));

        return [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'email', Rule::unique('users', 'email')->ignore($user_id)],
            'password' => ['nullable', 'string', 'min:6', 'max:20'],
            'role' => ['required', Rule::exists('roles', 'id')],
            'profile_image' => [
                'nullable', 'image', 'max:1048576', 'mimes:jpg,png,jpeg,gif,svg',
                function ($attribute, $value, $fail) {
                    /** @var UploadedFile $value */
                    $extension = strtolower($value->getClientOriginalExtension());
                    if ($extension === 'jfif') {
                        $fail('The uploaded image must be a valid image file (JPEG, PNG, JPG, GIF, SVG).');
                    }
                },
            ]
        ];
    }
}
