<?php

namespace App\Http\Requests;

use Spatie\Permission\Models\Role;
use Illuminate\Foundation\Http\FormRequest;

class UpdateRoleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules['name'] = 'required|string|max:255|unique:roles,name,'.\Crypt::decrypt($this->route('role'));
        $rules['permissions']=['required'];
        return $rules;
    }
    /**
     * @return array
     */
    public function messages()
    {
        return [
            'permissions.required'=>'Please choose the permissions for this role.'
        ];
    }
}
