<?php

namespace App\Http\Requests;

use App\Rules\XMLFileRule;
use App\Rules\TextFileRule;
use App\Rules\CheckFileNameRobot;
use App\Rules\CheckFileNameSiteMap;
use Illuminate\Foundation\Http\FormRequest;

class UpdateSettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'favicon' => ['mimes:png', 'max:1048576'],
            'left_icon' => [
                'nullable', 'max:1048576', 'mimes:jpg,png,jpeg,gif,svg',
                function ($attribute, $value, $fail) {
                    /** @var UploadedFile $value */
                    $extension = strtolower($value->getClientOriginalExtension());
                    if ($extension === 'jfif') {
                        $fail('The uploaded image must be a valid image file (JPEG, PNG, JPG, GIF, SVG).');
                    }
                },
            ],
            'right_icon' => [
                'nullable', 'max:1048576', 'mimes:jpg,png,jpeg,gif,svg',
                function ($attribute, $value, $fail) {
                    /** @var UploadedFile $value */
                    $extension = strtolower($value->getClientOriginalExtension());
                    if ($extension === 'jfif') {
                        $fail('The uploaded image must be a valid image file (JPEG, PNG, JPG, GIF, SVG).');
                    }
                },
            ],
            // 'facebook_icon'=>['mimes:jpeg,png,jpg,gif,svg','max:1048576'],
            'facebook_link' => 'nullable|string|max:255',
            // 'youtube_icon'=>['mimes:jpeg,png,jpg,gif,svg','max:1048576'],
            'youtube_link' => 'nullable|string|max:255',
            'main_title_en' => 'required|string|max:255',
            'main_title_mm' => 'required|string|max:255',
            'sub_title_en' => 'required|string|max:255',
            'sub_title_mm' => 'required|string|max:255',
            // 'phone_number'=>'required|string|max:255',
            // 'email'=>'required|email|string|max:255',
            'site_name_en' => 'required|string|max:255',
            'site_name_mm' => 'required|string|max:255',
            'date_format' => 'string|max:255',
            'footer_text_en' => 'string|max:255',
            'footer_text_mm' => 'string|max:255',
            // 'robots'=>[ 'file','max:1048576', new TextFileRule , new CheckFileNameRobot],
            // 'sitemap'=>[ 'file','max:1048576', new XMLFileRule , new CheckFileNameSiteMap]
        ];
    }
}
