<?php

namespace App\Models;

use App\Traits\ImageTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ContactUs extends Model
{
    use HasFactory,ImageTrait;

    const PHONE_IMAGE ='frontend/assets/image/contact-us/icon/phone.png';

    const EMAIL_IMAGE='frontend/assets/image/contact-us/icon/email.png';

    const ADDRESS_IMAGE='frontend/assets/image/contact-us/icon/address.png';

    const IMAGE_PATH = 'backend/page/contactus/';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'type',
        'logo_url',
        'map_url',
        'title',
        'title_mm',
        'desc',
        'meta_keyword',
        'meta_description',
    ];

    public function CreatedBy()
    {
        return $this->belongsTo(User::class, 'created_by')->withTrashed();
    }

    public function UpdatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by')->withTrashed();
    }
    public function menuItem()
    {
        return $this->belongsTo(MenuItems::class, 'menu_item_id');
    }
}
