<?php

namespace App\Models;

use App\Models\User;
use App\Models\PostFile as HomeFile;
use App\Traits\ImageTrait;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Home extends Model
{
    use HasFactory,Sluggable,ImageTrait;


    const IMAGE_PATH = 'backend/page/home/';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',
        'title_mm',
        'body',
        'body_mm',
        'slug',
        'menu_item_id',
        'link_to',
        'meta_keyword',
        'meta_description',
    ];
    public function CreatedBy()
    {
        return $this->belongsTo(User::class, 'created_by')->withTrashed();
    }

    public function UpdatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by')->withTrashed();
    }
    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'home'
            ]
        ];
    }
    public function menuItem()
    {
        return $this->belongsTo(MenuItems::class, 'menu_item_id');
    }
    public function bodyFiles()
    {
        return $this->morphMany(HomeFile::class,'model')->where('column_name','body');
    }
    public function bodyMMFiles()
    {
        return $this->morphMany(HomeFile::class,'model')->where('column_name','body_mm');
    }
    public function files()
    {
        return $this->morphMany(HomeFile::class,'model');
    }
    public function linkTo()
    {
        return $this->belongsTo(MenuItems::class, 'link_to');
    }
}
