<?php

namespace App\Models;

use App\Models\Menus;
use Illuminate\Database\Eloquent\Model;

class MenuItems extends Model
{
    const HOME_ID=1;
    const NEW_ID=2;
    const ABOUTUS_ID=3;
    const COMPANY_ID=4;
    const CONTACTUS_ID=5;
    const AWARENESS_ID=6;
    const SUGGESTION_ID=7;


    protected $table = null;

    protected $fillable = [
        'label', 
        'link', 
        'parent', 
        'sort', 
        'class', 
        'type', 
        'menu', 
        'depth', 
        'role_id',
        'status'
    ];

    public function __construct(array $attributes = [])
    {
        //parent::construct( $attributes );
        $this->table = config('menu.table_prefix') . config('menu.table_name_items');
    }

    public function getsons($id)
    {
        return $this->where("parent", $id)->get();
    }
    public function getall($id)
    {
        return $this->where("menu", $id)->orderBy("sort", "asc")->get();
    }

    public static function getNextSortRoot($menu)
    {
        return self::where('menu', $menu)->max('sort') + 1;
    }

    public function parent_menu()
    {
        return $this->belongsTo(Menus::class, 'menu');
    }

    public function child()
    {
        return $this->hasMany(self::class, 'parent')->orderBy('sort', 'ASC');
    }

}
