<?php

namespace App\Models;

use App\Models\User;
use App\Models\PostFile;
use App\Models\MenuItems;
use App\Traits\ImageTrait;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Post extends Model
{
    use HasFactory,ImageTrait,Sluggable;
    const IMAGE_PATH = 'backend/post/content-files/';
    const FEATURE_PATH = 'backend/post/feature-images/';
    const ATTACHED_PATH = 'backend/post/attach-files/';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',
        'title_mm',
        'body',
        'body_mm',
        'status',
        'slider',
        'slug',
        'menu_item_id',
        'meta_keyword',
        'meta_description',
        'created_by',
        'updated_by'
    ];
    // protected $guarded = [];
    public function CreatedBy()
    {
        return $this->belongsTo(User::class, 'created_by')->withTrashed();
    }

    public function UpdatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by')->withTrashed();
    }
    public function files()
    {
        return $this->morphMany(PostFile::class,'model');
    }
    public function bodyFiles()
    {
        return $this->morphMany(PostFile::class,'model')->where('column_name','body');
    }
    public function bodyMMFiles()
    {
        return $this->morphMany(PostFile::class,'model')->where('column_name','body_mm');
    }
    public function fileFiles()
    {
        return $this->morphMany(PostFile::class,'model')->where('column_name','file');
    }
    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }
    public function menuItem()
    {
        return $this->belongsTo(MenuItems::class, 'menu_item_id');
    }
}
