<?php

namespace App\Models;

use App\Traits\ImageTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Setting extends Model
{
    use HasFactory,ImageTrait;

    const FAVICON_ICON='backend/images/favicon.png';
    const LEFT_LOGO='frontend/assets/image/logo/left-logo.png';
    const RIGHT_LOGO='frontend/assets/image/logo/right-logo.png';
    const SITE_LOGO='backend/images/site_logo.png';

    const IMAGE_PATH = 'backend/setting/';
    const PUBLIC_PATH= '/';

    const FAVICON_KEY = 'favicon';
    const SITE_LOGO_KEY = 'site_logo';
    const ROBOT_KEY = 'robots';
    const SITEMAP_KEY = 'sitemap';
    const SITE_NAME = 'site_name';

    protected $table = 'settings';

    protected $fillable = [
        'key',
        'value',
        'display_name',
    ];
}
