<?php

namespace App\Models;

use App\Traits\ImageTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Suggestion extends Model
{
    use HasFactory,ImageTrait;
    const IMAGE_PATH = 'backend/page/suggestion/';

    protected $fillable = [
        'name',
        'phone',
        'nrc',
        'email',
        'address',
        'message',
    ];

    public function CreatedBy()
    {
        return $this->belongsTo(User::class, 'created_by')->withTrashed();
    }

    public function UpdatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by')->withTrashed();
    }
    public function files()
    {
        return $this->morphMany(PostFile::class,'model');
    }
    public function fileFiles()
    {
        return $this->morphMany(PostFile::class,'model')->where('column_name','file');
    }
}
