<?php

namespace App\Models;

use App\Traits\ImageTrait;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles, ImageTrait, SoftDeletes;

    const IMAGE_PATH = 'backend/profileimage/';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'status',
        'deleted_at',
        'profile_image',
        'login_at',
        'created_by',
        'updated_by'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function CreatedBy()
    {
        return $this->belongsTo(self::class, 'created_by');
    }

    public function UpdatedBy()
    {
        return $this->belongsTo(self::class, 'updated_by');
    }

    // public function profile_image_path()
    // {
    //     if ($this->profile_image) {
    //         return asset('/storage/'.$this->profile_image);
    //     }
    //     return null;
    // }
    public function deleteUserImage()
    {
        self::deleteImage($this->profile_image); // thumbnail

        $this->update(['profile_image' => null]);
    }

    public function roleName()
    {
        $role = $this->roles->first();

        return $role ? $role->name : '';
    }
}
