<?php

namespace App\Models;

use App\Models\User;
use App\Models\MenuItems;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Video extends Model
{
    use HasFactory,Sluggable;

    const FORMAT_VIDEO = 'video';
    const FORMAT_CHANNEL = 'channel_link';
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',
        'title_mm',
        'link',
        'meta_keyword',
        'meta_description',
    ];

    public function CreatedBy()
    {
        return $this->belongsTo(User::class, 'created_by')->withTrashed();
    }

    public function UpdatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by')->withTrashed();
    }
    public function menuItem()
    {
        return $this->belongsTo(MenuItems::class, 'menu_item_id');
    }
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }
}
