<?php

namespace App\Observers;

use App\Models\Book;
use App\Models\MenuItems;
use Illuminate\Support\Facades\Auth;
use Cviebrock\EloquentSluggable\Services\SlugService;

class BookObserver
{
    /**
     * Handle the Book "creating" event.
     *
     * @param  \App\Models\Book  $book
     * @return void
     */
    public function creating(Book $book)
    {
        $book->created_by=Auth::id() == 1?2:Auth::id();
        $book->menu_item_id=MenuItems::AWARENESS_ID;//Awareness
        $book->slug = SlugService::createSlug(Book::class, 'slug', $book->title);
    }

}
