<?php

namespace App\Observers;

use App\Models\ContactUs;
use App\Models\MenuItems;
use Illuminate\Support\Facades\Auth;
use Cviebrock\EloquentSluggable\Services\SlugService;

class ContactUsObserver
{

    /**
     * Handle the ContactUs "updating" event.
     *
     * @param  \App\Models\ContactUs  $contactus
     * @return void
     */
    public function updating(ContactUs $contactus)
    {
        $contactus->menu_item_id=MenuItems::CONTACTUS_ID;
        $contactus->updated_by=Auth::id() == 1?2:Auth::id();
        // $contactus->slug = SlugService::createSlug(ContactUs::class, 'slug', $contactus->title);
    }
}
