<?php

namespace App\Observers;

use App\Models\Home;
use Illuminate\Support\Facades\Auth;
use Cviebrock\EloquentSluggable\Services\SlugService;

class HomeObserver
{

    /**
     * Handle the Home "updating" event.
     *
     * @param  \App\Models\Home  $home
     * @return void
     */
    public function updating(Home $home)
    {
        $home->updated_by=Auth::id() == 1?2:Auth::id();
        $home->slug = SlugService::createSlug(Home::class, 'slug', $home->title);
    }
}
