<?php

namespace App\Observers;

use App\Models\Organization;
use Illuminate\Support\Facades\Auth;
use Cviebrock\EloquentSluggable\Services\SlugService;

class OrganizationObserver
{
    /**
     * Handle the Organization "updating" event.
     *
     * @param  \App\Models\Organization  $org
     * @return void
     */
    public function updating(Organization $org)
    {
        $org->updated_by=Auth::id() == 1?2:Auth::id();
        $org->slug = SlugService::createSlug(Organization::class, 'slug', $org->title);
    }
}
