<?php

namespace App\Observers;

use App\Models\Video;
use App\Models\MenuItems;
use Illuminate\Support\Facades\Auth;
use Cviebrock\EloquentSluggable\Services\SlugService;

class VideoObserver
{
    /**
     * Handle the Video "updating" event.
     *
     * @param  \App\Models\Video  $video
     * @return void
     */
    public function creating(Video $video)
    {
        $video->menu_item_id=MenuItems::AWARENESS_ID;
        $video->created_by=Auth::id() == 1?2:Auth::id();
        $video->slug = SlugService::createSlug(Video::class, 'slug', $video->title);
    }
}
