<?php

namespace App\Providers;

use App\Models\Book;
use App\Models\Home;
use App\Models\Post;
use App\Models\User;
use App\Models\Video;
use App\Models\ContactUs;
use App\Models\Organization;
use App\Observers\BookObserver;
use App\Observers\HomeObserver;
use App\Observers\PostObserver;
use App\Observers\UserObserver;
use App\Observers\VideoObserver;
use App\Observers\ContactUsObserver;
use Illuminate\Pagination\Paginator;
use App\Http\Controllers\Backend\WMenu;
use App\Observers\OrganizationObserver;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('laravel-menu', function () {
            return new WMenu();
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Paginator::useBootstrap();
        User::observe(UserObserver::class);
        Post::observe(PostObserver::class);
        Home::observe(HomeObserver::class);
        Organization::observe(OrganizationObserver::class);
        ContactUs::observe(ContactUsObserver::class);
        Book::observe(BookObserver::class);
        Video::observe(VideoObserver::class);
    }
}
