<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Repository\Backend\BookRepository;
use App\Repository\Backend\HomeRepository;
use App\Repository\Backend\PostRepository;
use App\Repository\Backend\RoleRepository;
use App\Repository\Backend\UserRepository;
use App\Repository\Backend\VideoRepository;
use App\Repository\Backend\SettingRepository;
use App\Repository\Backend\ContactUsRepository;
use App\Repository\Backend\SuggestionRepository;
use App\Repository\Backend\OrganizationRepository;
use App\Repository\Backend\Interfaces\BookRepositoryInterface;
use App\Repository\Backend\Interfaces\HomeRepositoryInterface;
use App\Repository\Backend\Interfaces\PostRepositoryInterface;
use App\Repository\Backend\Interfaces\RoleRepositoryInterface;
use App\Repository\Backend\Interfaces\UserRepositoryInterface;
use App\Repository\Backend\Interfaces\VideoRepositoryInterface;
use App\Repository\Backend\Interfaces\SettingRepositoryInterface;
use App\Repository\Backend\Interfaces\ContactUsRepositoryInterface;
use App\Repository\Backend\Interfaces\SuggestionRepositoryInterface;
use App\Repository\Backend\Interfaces\OrganizationRepositoryInterface;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
       // Register bindings for all repositories
       $this->app->bind(RoleRepositoryInterface::class, RoleRepository::class);
       $this->app->bind(UserRepositoryInterface::class, UserRepository::class);
       $this->app->bind(PostRepositoryInterface::class, PostRepository::class);
       $this->app->bind(HomeRepositoryInterface::class, HomeRepository::class);
       $this->app->bind(ContactUsRepositoryInterface::class, ContactUsRepository::class);
       $this->app->bind(OrganizationRepositoryInterface::class, OrganizationRepository::class);
       $this->app->bind(SuggestionRepositoryInterface::class, SuggestionRepository::class);
       $this->app->bind(BookRepositoryInterface::class, BookRepository::class);
       $this->app->bind(VideoRepositoryInterface::class, VideoRepository::class);
       $this->app->bind(SettingRepositoryInterface::class, SettingRepository::class);
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
