<?php

namespace App\Providers;

use App\Models\Setting;
use App\Models\ContactUs;
use App\Models\MenuItems;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class ViewServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        if (Schema::hasTable('migrations')) {
            $locale = Setting::where('key', 'language')->select('value')->first();
            if (isset($locale) && session()->get('default_locale') != $locale->value) {
                session()->put('default_locale', $locale->value);
                session()->put('locale', $locale->value);
            }
            view()->composer('*', function ($view) use ($locale) {
                $view->with('favicon', Setting::where('key', 'favicon')->select('value')->first())
                    ->with('site_name_en', Setting::where('key', 'site_name_en')->select('value')->first())
                    ->with('site_name_mm', Setting::where('key', 'site_name_mm')->select('value')->first())
                    ->with('site_logo', Setting::where('key', 'site_logo')->select('value')->first())
                    ->with('left_logo', Setting::where('key', 'left_logo')->select('value')->first())
                    ->with('right_logo', Setting::where('key', 'right_logo')->select('value')->first())
                    ->with('main_title_en', Setting::where('key', 'main_title_en')->select('value')->first())
                    ->with('main_title_mm', Setting::where('key', 'main_title_mm')->select('value')->first())
                    ->with('sub_title_en', Setting::where('key', 'sub_title_en')->select('value')->first())
                    ->with('sub_title_mm', Setting::where('key', 'sub_title_mm')->select('value')->first())
                    ->with('running_text', Setting::where('key', 'running_text')->select('value')->first())
                    ->with('date_format', Setting::where('key', 'date_format')->select('value')->first())
                    // ->with('facebook_icon',Setting::where('key','facebook_icon')->select('value')->first())
                    ->with('facebook_link', Setting::where('key', 'facebook_link')->select('value')->first())
                    // ->with('youtube_icon',Setting::where('key','youtube_icon')->select('value')->first())
                    ->with('youtube_link', Setting::where('key', 'youtube_link')->select('value')->first())
                    ->with('footer_text_en', Setting::where('key', 'footer_text_en')->select('value')->first())
                    ->with('footer_text_mm', Setting::where('key', 'footer_text_mm')->select('value')->first())
                    ->with('locale', $locale->value)
                    ->with('menu_items', MenuItems::select('id', 'label', 'label_mm', 'parent', 'slug', 'link')->where('depth', 1)->orderBy('sort','asc')->where('status', 'active')->get())

                    ->with('phone', ContactUs::where('type', 'phone')->select('logo_url', 'title', 'title_mm', 'desc', 'desc_mm')->first())
                    ->with('email', ContactUs::where('type', 'email')->select('logo_url', 'title', 'title_mm', 'desc', 'desc_mm')->first());
            });
        }
    }
}
