<?php
namespace App\Repository\Backend;

use App\Models\ContactUs;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Repository\Backend\BaseRepository;
use App\Repository\Backend\Interfaces\ContactUsRepositoryInterface;

class ContactUsRepository extends BaseRepository implements ContactUsRepositoryInterface
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'title',
        'title_mm',
        'desc',
        'desc_mm',
    ];
    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return ContactUs::class;
    }

    /**
     * @param  array  $search
     *
     * @return ContactUs[]|Collection|int
     */
    public function all($search = [])
    {
       //
    }
       /**
     * @param  array  $input
     *
     * @return mixed
     */
    public function store($input)
    {
        //
    }
     /**
     * @param  array  $input
     * @param  int  $id
     *
     * @return ContactUs
     */
    public function update($input, $id)
    {

        try {
            DB::beginTransaction();
            $logs=[];
            for($i=0;$i<3;$i++)
            {
                $contact=ContactUs::find($i+1);// id are 1,2 and 3
                $logo_name='logo'.($i+1).'_url';//logo1_url, logo2_url , logo3_url
                // dd($logo_name);
                if(!empty($input[$logo_name]))
                {
                    ContactUs::deleteImage($contact->logo_url);
                    $featureImagePath = ContactUs::makeImage($input[$logo_name], ContactUs::IMAGE_PATH);
                    $contact->logo_url= $featureImagePath;

                }
                $contact->title=$input['title'][$i];
                $contact->title_mm=$input['title_mm'][$i];
                $contact->desc=$input['desc'][$i];
                $contact->desc_mm=$input['desc_mm'][$i];
                $contact->update();
                array_push($logs,$contact);

            }


            $map=ContactUs::find(4);
            $map->map_frame=$input['map_frame'];
            $map->updated_by=Auth::id() == 1?2:Auth::id();;
            $map->save();
            array_push($logs,$map);
            save_logs('Update Contact Us',$logs);
            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->withErrors(new \Illuminate\Support\MessageBag(['catch_exception'=>$e->getMessage()]));
        }

        return true;
    }
}
