<?php
namespace App\Repository\Backend;

use App\Models\Home;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Builder;
use App\Repository\Backend\BaseRepository;
use App\Repository\Backend\Interfaces\HomeRepositoryInterface;

class HomeRepository extends BaseRepository implements HomeRepositoryInterface
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'body',
        'body_mm',
    ];
    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Home::class;
    }

    /**
     * @param  array  $search
     *
     * @return Home[]|Collection|int
     */
    public function all($search = [])
    {
       //
    }
       /**
     * @param  array  $input
     *
     * @return mixed
     */
    public function store($input)
    {
        //
    }
     /**
     * @param  array  $input
     * @param  int  $id
     *
     * @return Home
     */
    public function update($input, $id)
    {
        // dd($input);
        /** @var Home $role */
        $home = Home::findOrFail($id);
        //delete files for old body
        // if(isset($home->bodyFiles))
        // {
        //     foreach($home->bodyFiles as $bfile)
        //     {
        //         Home::deleteImage($bfile->file_url);
        //         $bfile->delete();
        //     }
        // }
        // //delete files for old body_mm
        // if(isset($home->bodyMMFiles))
        // {
        //     foreach($home->bodyMMFiles as $bfile)
        //     {
        //         Home::deleteImage($bfile->file_url);
        //         $bfile->delete();
        //     }
        // }
        try {
            DB::beginTransaction();
            /** @var Home $home */
            // $input_body=json_decode($input['body']);
            // $input['body']='temp text';
            // $input_body_mm=json_decode($input['body_mm']);
            // $input['body_mm']='temp text';
            $home->update($input);

            //here to delete old image and old files

            // body english (save url instead of base64 encode data)
            // foreach($input_body->blocks as $key=>$body)
            // {
            //     if(isset($body->type) && $body->type=='image')
            //     {
            //         // dd($body);
            //         $filePath=Home::makeImageFromBase64($body->data->url,Home::IMAGE_PATH,$body->id);
            //         $input_body->blocks[$key]->data->url=asset('storage/'.$filePath);
            //         $home->files()->create([
            //             'file_url'=>$filePath,
            //             'column_name'=>'body',
            //         ]);
            //     }
            // }
            // $home->body=json_encode($input_body);
            // //body myanmar
            // foreach($input_body_mm->blocks as $key=>$body)
            // {
            //     if(isset($body->type) && $body->type=='image')
            //     {

            //         $filePath=Home::makeImageFromBase64($body->data->url,Home::IMAGE_PATH,$body->id);
            //         $input_body_mm->blocks[$key]->data->url=asset('storage/'.$filePath);
            //         $home->files()->create([
            //             'file_url'=>$filePath,
            //             'column_name'=>'body_mm',
            //         ]);
            //     }
            // }
            // $home->body_mm=json_encode($input_body_mm);

            // $home->update();
            save_logs('Update Home',$home);

            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->withErrors(new \Illuminate\Support\MessageBag(['catch_exception'=>$e->getMessage()]));
        }

        return $home;
    }
    /**
     * @param  array  $search
     * @param  Builder  $query
     *
     * @return Builder
     */
    // public function applyDynamicSearch($search, $query)
    // {

    //     $query->when(! empty($search['search']), function (Builder $query) use ($search) {
    //         $query->orWhereHas('roles', function (Builder $query) use ($search) {
    //             filterByColumns($query, $search['search'], ['name']);
    //         });
    //     });

    //     return $query;
    // }
}
