<?php
namespace App\Repository\Backend\Interfaces;

/**
 * Interface ContactUsRepositoryInterface
 */
interface ContactUsRepositoryInterface
{
    /**
     * @return array
     */
    public function getFieldsSearchable();

    /**
     * @return mixed
     */
    public function model();

    /**
     * @param  array  $search
     *
     * @return ContactUs[]|Collection|int
     */
    public function all($search = []);

    /**
     * @param  array  $input
     *
     */
    public function store($input);

    /**
     * @param  array  $input
     * @param  int  $id
     *
     * @return JsonResponse|mixed
     */
    public function update($input, $id);
}
