<?php
namespace App\Repository\Backend;

use App\Models\Organization;
use Illuminate\Support\Facades\DB;
use App\Repository\Backend\BaseRepository;
use App\Repository\Backend\Interfaces\OrganizationRepositoryInterface;

class OrganizationRepository extends BaseRepository implements OrganizationRepositoryInterface
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'body',
        'body_mm',
    ];
    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Organization::class;
    }

    /**
     * @param  array  $search
     *
     * @return Organization[]|Collection|int
     */
    public function all($search = [])
    {
       //
    }
       /**
     * @param  array  $input
     *
     * @return mixed
     */
    public function store($input)
    {
        //
    }
     /**
     * @param  array  $input
     * @param  int  $id
     *
     * @return Organization
     */
    public function update($input, $id)
    {

        try {
            DB::beginTransaction();
            // dd($input);
            /** @var Organization $role */
            $org = Organization::findOrFail($id);

            $org->update($input);

            if(!empty($input['feature_image']))
            {
                Organization::deleteImage($org->feature_image);
                $featureImagePath = Organization::makeImage($input['feature_image'], Organization::IMAGE_PATH);
                $org->feature_image= $featureImagePath;
                // dd($org);
            }
            $org->update();
            save_logs('Update Organization',$org);
            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->withErrors(new \Illuminate\Support\MessageBag(['catch_exception'=>$e->getMessage()]));
        }

        return $org;
    }
}
