<?php
namespace App\Repository\Backend;

use App\Models\Setting;
use Illuminate\Support\Facades\DB;
use App\Repository\Backend\BaseRepository;
use App\Repository\Backend\Interfaces\SettingRepositoryInterface;

class SettingRepository extends BaseRepository implements SettingRepositoryInterface
{
    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }
    /**
     * Configure the Model
     **/
    public function model()
    {
        return Setting::class;
    }


     /**
     * @param  array  $input
     * @param  int  $id
     *
     * @return Setting
     */
    public function update($input, $id)
    {
        try {
            DB::beginTransaction();
            unset($input['content']['_method']);
            unset($input['content']['_token']);
            $logs=[];
            foreach($input['content'] as $key=>$value)
            {

                $setting=Setting::where('key',$key)->update(['value'=>$value]);
                array_push($logs,[$key=>$value]);

            }
            foreach($input['files'] as $key=>$value)
            {
                $setting=Setting::where('key',$key)->first();
                if($key==Setting::ROBOT_KEY || $key==Setting::SITEMAP_KEY)
                {
                    Setting::deleteFileSEO($setting->value);
                    $featureImagePath = Setting::makeAttachmentSEO($value, Setting::PUBLIC_PATH);
                }else{

                    Setting::deleteImage($setting->value);
                    $featureImagePath = Setting::makeImage($value, Setting::IMAGE_PATH);
                }

                $setting->value=$featureImagePath;
                $setting->save();
                array_push($logs,[$key=>$value]);
            }
            save_logs('Update Setting',$logs);
            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->withErrors(new \Illuminate\Support\MessageBag(['catch_exception'=>$e->getMessage()]));
        }

        return true;
    }
}
