<?php
namespace App\Repository\Backend;

use App\Models\Video;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Repository\Backend\BaseRepository;
use App\Repository\Backend\Interfaces\VideoRepositoryInterface;

class VideoRepository extends BaseRepository implements VideoRepositoryInterface
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'title',
        'title_mm',
    ];
    /**
     * Return searchable fields
     *
     * @return array
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Video::class;
    }

    /**
     * @param  array  $search
     *
     * @return Video[]|Collection|int
     */
    public function all($search = [])
    {
        $orderBy = null;
        if (! empty($search['order_by']) && in_array($search['order_by'],
                ['name'])) {
            $orderBy = $search['order_by'];
            unset($search['order_by']);
        }
        $query = $this->allQuery($search);
        if(isset($search['status']) && $search['status'])
        {
            $query->where('status',$search['status']);
        }
        // dd($search);
        $videoRecords = $query->paginate($search['paginate']);

        $videoRecords = $query->orderByDesc('id')->paginate($search['paginate']);

        if (! empty($orderBy)) {
            $sortDescending = ($search['direction'] == 'asc') ? false : true;
            $orderString = '';
            if ($orderBy == 'name') {
                $orderString = 'name';
            }

            $videoRecords = $videoRecords->sortBy($orderString, SORT_REGULAR, $sortDescending);
        }

        return $videoRecords;
    }
       /**
     * @param  array  $input
     *
     * @return mixed
     */
    public function store($input)
    {
        try {
            DB::beginTransaction();

            $video=Video::create($input);
            save_logs('Create Video',$video);//call helpers method


            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->withErrors(new \Illuminate\Support\MessageBag(['catch_exception'=>$e->getMessage()]));
        }

        return $video;
    }
     /**
     * @param  array  $input
     * @param  int  $id
     *
     * @return Video
     */
    public function update($input, $id)
    {
        try {
            DB::beginTransaction();

            /** @var Video $video */
            $video = $this->findOrFail($id);
            $video->update($input);
            $video->updated_by=Auth::id() == 1?2:Auth::id();
            $video->save();

            save_logs('Update Video',$video);//call helpers method


            DB::commit();

            return $video;
        } catch (Exception $e) {
            throw $e;
            DB::rollBack();
            return redirect()->back()->withErrors(new \Illuminate\Support\MessageBag(['catch_exception'=>$e->getMessage()]));
        }
    }

}
