<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class FileCount implements Rule
{
    protected $min;
    protected $max;
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct($min,$max)
    {
        $this->min=$min;
        $this->max=$max;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {

        if(!is_array($value))
        {
            $value=[$value];
        }
        $count=count($value);
        return $count >= $this->min && $count <=$this->max;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return "The :attribute must have between {$this->min} and {$this->max} files.";
    }
}
