<?php
use Illuminate\Support\Facades\Log;
use Illuminate\Database\Eloquent\Builder;

/**
 * @param  Builder  $query
 * @param  string  $keywords
 * @param  array  $columns
 *
 * @return mixed
 */
function filterByColumns(&$query, $keywords, $columns)
    {
        $keywords = explode_trim_remove_empty_values_from_array($keywords, ' ');

        $query->where(function (Builder $query) use ($keywords, $columns) {
            foreach ($keywords as $keyword) {
                foreach ($columns as $column) {
                    $query->orWhereRaw("lower($column) LIKE ?", ['%'.trim(strtolower($keyword)).'%']);
                }
            }
        });

        return $query;
    }
/**
 * @param  string  $str
 * @param  string  $delimiter
 *
 * @return array
 */
function explode_trim_remove_empty_values_from_array($str, $delimiter = ',')
    {
        $arr = explode($delimiter, trim($str));
        $arr = array_map('trim', $arr);
        $arr = array_filter($arr, function ($value) {
            return ! empty($value);
        });

        return $arr;
    }

function save_logs($action,$obj)
    {
        Log::channel('daily')->info($action,
            [
                'causer_id'=>auth()->id(),
                'data'=>$obj
            ]
        );
    }
function convert($string, $lang = 'mm')
    {
        $mm = ['၀','၁', '၂', '၃', '၄', '၅', '၆','၇','၈','၉'];

        $num = range(0, 9);
    switch ($lang) {
        case 'mm':
            return str_replace($num, $mm, $string);
            break;

        case 'en':
            return str_replace($mm, $num, $string);
            break;

        default:
            return $string;
            break;
        }
    }
function convert_full_month($string, $lang = 'mm')
    {
        $mm = ['တနင်္လာ','အင်္ဂါ','ဗုဒ္ဓဟူး','ကြာသပတေး','သောကြာ','စနေ','တနင်္ဂနွေ','ဇန်နဝါရီ','ဖေဖော်ဝါရီ', 'မတ်', 'ဧပရယ်', 'မေ', 'ဇွန်', 'ဇူလှိုင်','ဩဂတ်','စက်တင်ဘာ','အောက်တိုဘာ','နိုဝင်ဘာ','ဒီဇင်ဘာ','ဇန်နဝါရီ','ဖေဖော်ဝါရီ', 'မတ်', 'ဧပရယ်', 'မေ', 'ဇွန်', 'ဇူလှိုင်','ဩဂတ်','စက်တင်ဘာ','အောက်တိုဘာ','နိုဝင်ဘာ','ဒီဇင်ဘာ','၀','၁', '၂', '၃', '၄', '၅', '၆','၇','၈','၉'];

        $num = ['Mon','Tue','Wed','Thur','Fri','Sat','Sun','January','February','March','April','May','June','July','August','September','October','November','December','Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec','0','1','2','3','4','5','6','7','8','9'];
    switch ($lang) {
        case 'mm':
            return str_replace($num, $mm, $string);
            break;

        case 'en':
            return str_replace($mm, $num, $string);
            break;

        default:
            return $string;
            break;
        }
    }
