<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContactUsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contact_us', function (Blueprint $table) {
            $table->id();
            $table->string('type');
            $table->text('map_frame')->nullable();
            $table->binary('logo_url')->nullable();
            $table->string('title')->nullable();
            $table->string('title_mm')->nullable();
            $table->text('desc')->nullable();
            $table->text('desc_mm')->nullable();
            $table->string('slug')->nullable();
            $table->unsignedBigInteger('menu_item_id');
            $table->foreignId('created_by')->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->timestamps();

            $table->foreign('menu_item_id')
                ->references('id')
                ->on('menu_items');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contact_us');
    }
}
