<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MenuItemTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $homeUrl=route('home');
        $newsUrl=route('news');
        $companyUrl=route('company');
        $contactUrl=route('contact-us');
        $awarenessUrl=route('awareness');
        $suggestionUrl=route('suggestion');
        DB::table('menu_items')->insert([
            [
                'label' => 'Home',
                'label_mm' => 'Home',
                'link' => $homeUrl,
                'parent' => 0,
                'sort' => 0,
                'class' => null,
                'type' => 'page',
                'menu' => 1,
                'depth' => 1,
                'status' => 'active',
                'role_id' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'label' => 'News',
                'label_mm' => 'News',
                'link' => $newsUrl,
                'parent' => 0,
                'sort' => 1,
                'class' => null,
                'type' => 'post',
                'menu' => 1,
                'depth' => 1,
                'status' => 'active',
                'role_id' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'label' => 'About Us',
                'label_mm' => 'About Us',
                'link' => '#',
                'parent' => 0,
                'sort' => 2,
                'class' => null,
                'type' => 'page',
                'menu' => 1,
                'depth' => 1,
                'status' => 'active',
                'role_id' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'label' => 'Company',
                'label_mm' => 'Company',
                'link' => $companyUrl,
                'parent' => 3,
                'sort' => 3,
                'class' => null,
                'type' => 'page',
                'menu' => 1,
                'depth' => 2,
                'status' => 'active',
                'role_id' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'label' => 'Contact Us',
                'label_mm' => 'Contact Us',
                'link' => $contactUrl,
                'parent' => 3,
                'sort' => 4,
                'class' => null,
                'type' => 'page',
                'menu' => 1,
                'depth' => 2,
                'status' => 'active',
                'role_id' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'label' => 'Awareness',
                'label_mm' => 'Awareness',
                'link' => $awarenessUrl,
                'parent' => 0,
                'sort' => 5,
                'class' => null,
                'type' => 'all',
                'menu' => 1,
                'depth' => 1,
                'status' => 'active',
                'role_id' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'label' => 'Suggestion',
                'label_mm' => 'Suggestion',
                'link' => $suggestionUrl,
                'parent' => 0,
                'sort' => 6,
                'class' => null,
                'type' => 'page',
                'menu' => 1,
                'depth' => 1,
                'status' => 'active',
                'role_id' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ]);
    }
}
