<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            'book_list',
            'book_create',
            'book_edit',
            'book_delete',

            'menu_list',
            'menu_edit',

            'page_list',
            // 'page_create',
            'page_edit',
            // 'page_delete',

            'post_list',
            'post_create',
            'post_edit',
            'post_delete',

            'role_list',
            'role_create',
            'role_edit',
            'role_delete',

            'user_list',
            'user_create',
            'user_edit',
            'user_delete',

            'setting_edit',

            'video_list',
            'video_create',
            'video_edit',
            'video_delete',

            'book_status',
            // 'page_status',
            'post_status',
            'user_status',
            // 'log_view',
            // 'log_delete',
        ];
        foreach ($permissions as $permission) {
            Permission::create(['name'=>$permission]);
        }
    }
}
