<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        \DB::table('settings')->insert([
            [
                'key' => 'favicon',
                'value' => '-',
                'display_name' => 'Favicon Icon',
            ],
            [
                'key' => 'left_logo',
                'value' => '-',
                'display_name' => 'Left Icon',
            ],
            [
                'key' => 'right_logo',
                'value' => '-',
                'display_name' => 'Right Icon',
            ],
            [
                'key' => 'site_logo',
                'value' => '-',
                'display_name' => 'System Login Logo',
            ],
            [
                'key' => 'site_name_en',
                'value' => 'ACCM',
                'display_name' => 'Sytem Name(English)',
            ],
            [
                'key' => 'site_name_mm',
                'value' => 'ACCM',
                'display_name' => 'Sytem Name(Myanmar)',
            ],
            [
                'key' => 'main_title_en',
                'value' => 'Kachin State',
                'display_name' => 'Main Title(English)',
            ],
            [
                'key' => 'main_title_mm',
                'value' => 'ကချင်ပြည်နယ်',
                'display_name' => 'Main Title(Myanmar)',
            ],
            [
                'key' => 'sub_title_en',
                'value' => 'Corruption Prevention Unit',
                'display_name' => 'Sub Title(English)',
            ],
            [
                'key' => 'sub_title_mm',
                'value' => '-',
                'display_name' => 'Sub Title(Myanmar)',
            ],
            [
                'key' => 'phone_number',
                'value' => '-',
                'display_name' => 'Phone Number',
            ],
            [
                'key' => 'email',
                'value' => 'cpu@gmail.com',
                'display_name' => 'Email',
            ],
            [
                'key' => 'facebook_icon',
                'value' => '-',
                'display_name' => 'Facebook Icon',
            ],
            [
                'key' => 'facebook_link',
                'value' => '#',
                'display_name' => 'Facebook Link',
            ],
            [
                'key' => 'youtube_icon',
                'value' => '-',
                'display_name' => 'Footer Youtube Icon',
            ],
            [
                'key' => 'youtube_link',
                'value' => '#',
                'display_name' => 'Footer Youtube Link',
            ],
            [
                'key' => 'footer_text_en',
                'value' => 'Corruption Prevention Unit',
                'display_name' => 'Footer Text(English)',
            ],
            [
                'key' => 'footer_text_mm',
                'value' => 'Corruption Prevention Unit',
                'display_name' => 'Footer Text(Myanmar)',
            ],
            [
                'key' => 'robots',
                'value' => '-',
                'display_name' => 'Robots File(.txt)',
            ],
            [
                'key' => 'sitemap',
                'value' => '-',
                'display_name' => 'Sitemap File(.xml)',
            ],
            [
                'key' => 'date_format',
                'value' => 'd.m.Y',
                'display_name' => 'System Date Format',
            ],
            [
                'key' => 'running_text',
                'value' => 'အဂတိလိုက်စားမှု တိုက်ဖျက်ရေးကော်မရှင်၏ အဂတိလိုက်စားမှု တိုက်ဖျက်ရေး လုပ်ငန်းဆောင်ရွက်ချက်များ',
                'display_name' => 'Running Text',
            ],
            [
                'key' => 'language',
                'value' => 'mm',
                'display_name' => 'System Default Language',
            ],
        ]);
        // $setting=new Setting;
        // $setting->key = 'running_text';
        // $setting->value = 'အဂတိလိုက်စားမှု တိုက်ဖျက်ရေးကော်မရှင်၏ အဂတိလိုက်စားမှု တိုက်ဖျက်ရေး လုပ်ငန်းဆောင်ရွက်ချက်များ';
        // $setting->display_name = 'Running Text';
        // $setting->save();
    }
}
