@extends('backend.layouts.app_plain')
@section('title', 'Admin Login')
@section('content')
    <div class="home-btn d-none d-sm-block">
        <a href="#"></a>
    </div>
    <div class="account-pages my-5 pt-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-6 col-xl-5">
                    <div class="card">
                        <div class="card-body">
                            <div class="text-center mt-4">
                                <div class="mb-3">
                                    <a href="#" class="">
                                        @if (isset($site_logo->value) && Storage::disk('public')->exists($site_logo->value))
                                            <img src="{{ asset('storage/' . $site_logo->value) }}" alt=""
                                                height="70" class="auth-logo logo-dark mx-auto">
                                        @else
                                            <img src="{{ asset(Setting::SITE_LOGO) }}" alt="" height="70"
                                                class="auth-logo logo-dark mx-auto">
                                        @endif
                                    </a>
                                </div>
                            </div>
                            <div class="p-1">
                                <h4 class="font-size-18 text-muted mb-4 text-center">
                                    @if (isset($site_name_en->value))
                                        {{ __("$site_name_en->value") }}
                                    @else
                                        {{ __('ANTI-CORRUPTION COMMISION') }}
                                    @endif
                                </h4>

                                <form class="form-horizontal" action="{{ route('admin-login') }}" method="post">
                                    @csrf
                                    <div class="mb-3">
                                        <label class="form-label" for="email">{{ __('E-mail Address') }}</label>
                                        <input type="text" class="form-control @error('email') is-invalid @enderror"
                                            id="email" name="email" placeholder="{{ __('Enter email') }}"
                                            value="{{ old('email') }}" required autofocus>
                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label" for="password">{{ __('Password') }}</label>
                                        <div class="input-group">
                                            <input type="password"
                                                class="form-control input-password @error('password') is-invalid @enderror"
                                                name="password" placeholder="{{ __('Enter password') }}" required>
                                            <button class="toggle-password" type="button"
                                                aria-label="Show password as plain text. Warning: this will display your password on the screen.">
                                            </button>
                                            {{-- <div class="input-group-append">
                                            <button class="btn btn-outline-secondary toggle-password" type="button">
                                                <i class="fa fa-eye-slash"></i>
                                            </button>
                                        </div> --}}
                                        </div>

                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <!-- end row -->
                                    {{-- <div class="row">
                                    <div class="col-md-12 col-xs-12">
                                        <div class="form-group mb-3">
                                            <div class="checkbox">
                                                <label>
                                                    <a href="">{{__("Forget Password?")}}</a>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                </div> --}}

                                    <div class="row mb-4">
                                        <div class="col-12 text-center">
                                            <button class="btn btn-primary w-100 waves-effect waves-light"
                                                type="submit">Log
                                                In</button>
                                        </div>
                                    </div>
                                    @if (session()->has('fail'))
                                        <div class="alert alert-danger">
                                            {{ session()->get('fail') }}
                                        </div>
                                    @endif
                                    <!-- end row -->
                                </form>
                                <!-- end form -->
                            </div>
                        </div>
                        <!-- end cardbody -->
                    </div>
                    <!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->
        </div>
    </div>
@endsection
@section('custom_js')
    @include('common.showpassword')
@endsection
